(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      5675,        170]
NotebookOptionsPosition[      4760,        146]
NotebookOutlinePosition[      5188,        163]
CellTagsIndexPosition[      5145,        160]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"<<", "VilGebra`"}]], "Input",
 CellChangeTimes->{{3.916306810908575*^9, 3.9163068179963284`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"970a1b2c-573e-c142-96c5-8eadc9eb8bfb"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     StyleBox["\<\"\|01f680 VilGebra cargado\"\>",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontSize->16,
      FontWeight->Bold,
      FontColor->RGBColor[0, 0, 1]]},
    {
     StyleBox["\<\"\:2705 Listo para usar. Versi\[OAcute]n del \
03/09/2025.\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontWeight->Bold,
      FontColor->GrayLevel[0]]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Print",
 CellChangeTimes->{3.972058329659997*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"9b9d014f-ef57-491e-9833-1abc3e7f9f60"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"N1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N2", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "3"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"d", "=", 
  RowBox[{"Cross", "[", 
   RowBox[{"N1", ",", "N2"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"P", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "y", ",", "z"}], "}"}], "/.", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "+", 
          RowBox[{"2", "y"}], "-", "z"}], "==", "3"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "x"}], "-", "y", "+", 
          RowBox[{"3", "z"}]}], "==", "1"}]}], "}"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
   RowBox[{"x", "->", "1"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"EcuacVecToSime", "[", 
  RowBox[{"P", "+", 
   RowBox[{"t", " ", "d"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.97205750028043*^9, 3.972057622542642*^9}, {
  3.9720583035239077`*^9, 3.972058320744546*^9}, {3.972058367443218*^9, 
  3.972058383522739*^9}, {3.972058853745878*^9, 3.972058902782509*^9}, {
  3.97205969527569*^9, 3.972059902934792*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"f5f6c89d-cabc-4c77-894f-1eab9a3a9900"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", 
   RowBox[{"-", "5"}], ",", 
   RowBox[{"-", "5"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.972057643951844*^9, 3.972058383860136*^9, 3.972058903360661*^9, 
   3.9720597886868153`*^9, {3.972059819628442*^9, 3.972059827341218*^9}, {
   3.9720598736653214`*^9, 3.972059903444676*^9}},
 CellLabel->"Out[32]=",ExpressionUUID->"8b0de5e3-6b26-4748-8e77-e4b0bdf46c8f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.972057643951844*^9, 3.972058383860136*^9, 3.972058903360661*^9, 
   3.9720597886868153`*^9, {3.972059819628442*^9, 3.972059827341218*^9}, {
   3.9720598736653214`*^9, 3.972059903445396*^9}},
 CellLabel->"Out[33]=",ExpressionUUID->"f87867e1-1cb5-4862-bede-4850ef715e34"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "5"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"=\"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"1", "-", "y"}], "5"], "\[InvisibleSpace]", "\<\"=\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox["z", "5"]}]}],
  SequenceForm[
  Rational[1, 5] (-1 + $CellContext`x), "=", 
   Rational[1, 5] (1 - $CellContext`y), "=", Rational[-1, 5] $CellContext`z],
  Editable->False]], "Print",
 CellChangeTimes->{3.972059903446089*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[30]:=",ExpressionUUID->"e5f12b33-fa83-4913-837f-448aba6b915f"]
}, Open  ]]
},
WindowSize->{1319, 786},
WindowMargins->{{-1410, Automatic}, {21, Automatic}},
Magnification:>1.25 Inherited,
FrontEndVersion->"14.3 para Mac OS X ARM (64-bit) (July 8, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"b14c32af-361e-497c-b469-f48e546e10d9"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 199, 3, 73, "Input",ExpressionUUID->"970a1b2c-573e-c142-96c5-8eadc9eb8bfb"],
Cell[782, 27, 1003, 30, 107, "Print",ExpressionUUID->"9b9d014f-ef57-491e-9833-1abc3e7f9f60"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1822, 62, 1409, 39, 403, "Input",ExpressionUUID->"f5f6c89d-cabc-4c77-894f-1eab9a3a9900"],
Cell[3234, 103, 415, 9, 83, "Output",ExpressionUUID->"8b0de5e3-6b26-4748-8e77-e4b0bdf46c8f"],
Cell[3652, 114, 377, 7, 83, "Output",ExpressionUUID->"f87867e1-1cb5-4862-bede-4850ef715e34"],
Cell[4032, 123, 712, 20, 78, "Print",ExpressionUUID->"e5f12b33-fa83-4913-837f-448aba6b915f"]
}, Open  ]]
}
]
*)

